function CDX = set_zero_RP_MPR_idio(CDX, k_P)
% --------------------------------------------------------------------------------------------------
% Set the market price of idiosyncratic risk equal to zero
% --------------------------------------------------------------------------------------------------
% CDX                       ... credit index structure (see 'all_steps_in_a_row.m')
% k_P                       ... mean reversion speed for idiosyncratic risk factors
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_MPR_idio(cdx_tv_monthly10, 0.5)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    cds.AJD.theta = cds.AJD.theta .* cds.AJD.k / k_P;
    cds.AJD.k = repmat(k_P, size(cds.AJD.k));
    CDX.portfolio(i) = cds;
end